% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_array_pct.R
\name{api-pct-operations}
\alias{api-pct-operations}
\alias{\%a+\%}
\alias{\%a-\%}
\alias{\%a*\%}
\alias{\%a/\%}
\alias{\%a/0\%}
\alias{\%a_\%}
\alias{\%a==\%}
\alias{\%a^\%}
\alias{\%aperm\%}
\alias{\%aalign\%}
\alias{\%aslice\%}
\alias{\%aslice*\%}
\alias{\%amarg\%}
\title{Array algebra}
\usage{
a1 \%a+\% a2

a1 \%a-\% a2

a1 \%a*\% a2

a1 \%a/\% a2

a1 \%a/0\% a2

tab1 \%a_\% marg

tab1 \%a==\% tab2

tab1 \%a^\% extra

tab1 \%aperm\% perm

tab1 \%aalign\% tab2

tab1 \%aslice\% slice

tab1 \%aslice*\% slice

tab1 \%amarg\% marg
}
\arguments{
\item{tab1, tab2}{Multidimensional arrays with named dimnames
(we call them 'named arrays').}

\item{marg}{A vector of indices or dimnames or a right hand sided
formula giving the desired marginal.}

\item{extra}{List defining the extra dimensions.}

\item{perm}{A vector of indices or dimnames or a right hand sided
formula giving the desired permutiation.}

\item{slice}{A list of the form name=value.}

\item{a, a1, a2}{Arrays (with named dimnames)}
}
\description{
Addition, subtraction etc. of arrays
}
\examples{
hec <- HairEyeColor
a1 <- tabMarg(hec, c("Hair", "Eye"))
a2 <- tabMarg(hec, c("Hair", "Sex"))
a3 <- tabMarg(hec, c("Eye", "Sex"))

## Binary operations
a1 \%a+\% a2
a1 \%a-\% a2
a1 \%a*\% a2
a1 \%a/\% a2
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
