% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gFormulaImpute.R
\name{gFormulaImpute}
\alias{gFormulaImpute}
\title{G-formula multiple imputation}
\usage{
gFormulaImpute(
  data,
  M = 50,
  trtVars,
  trtRegimes,
  nSim = NULL,
  micePrintFlag = FALSE,
  silent = FALSE,
  method = NULL,
  predictorMatrix = NULL
)
}
\arguments{
\item{data}{The observed data frame}

\item{M}{The number of imputed datasets to generate}

\item{trtVars}{A vector of variable names indicating the time-varying treatment variables}

\item{trtRegimes}{A vector specifying the treatment regime of interest, or a list of
vectors specifying the treatment regimes of interest}

\item{nSim}{The number of individuals to simulate in each imputed dataset. Defaults to
number of individuals in observed data}

\item{micePrintFlag}{TRUE/FALSE specifying whether the output from the call(s) to mice
should be printed}

\item{silent}{TRUE/FALSE indicating whether to print output to console (FALSE) or not (TRUE)}

\item{method}{An optional method argument to pass to mice. If not specified, the default
is to impute continuous variables using normal linear regression (norm), binary variables using
logistic regression (logreg), polytomous regression for unordered factors and
proportional odds model for ordered factors}

\item{predictorMatrix}{An optional predictor matrix to specify which variables to use
as predictors in the imputation models. The default is to impute sequentially, i.e. impute
using all variables to the left of the variable being imputed as covariates}
}
\value{
an S3 object of class mids (multiply imputed dataset)
}
\description{
\code{gFormulaImpute} creates multiple imputed synthetic datasets of longitudinal histories under
specified treatment regimes of interest, based on the G-formula.
}
\details{
\code{gFormulaImpute} creates multiple imputed synthetic datasets of longitudinal histories under
specified treatment regimes of interest, based on the G-formula, as described in
\href{https://arxiv.org/abs/2301.12026}{Bartlett et al 2023}. Specifically, to
the observed data frame, an additional \code{nSim} rows are added in which all variables are set to
missing, except the time-varying treatment variables. The latter are set to the values
as specified in the \code{trtRegimes} argument. If multiple treatment regimes are specified,
\code{nSim} rows are added for each of the specified treatment regimes.

\code{gFormulaImpute} uses the \code{mice} package to impute the potential outcome values of the
time-varying confounders and outcome in the synthetic datasets. Imputation is performed
sequentially from left to right in the data frame. As such, the variables must be ordered
in time in the input data frame, with the time-varying confounders at each time followed
by the corresponding treatment variable at that time.

For the data argument, \code{gFormulaImpute} expects either a fully observed (complete) data frame,
or else a set of multiple imputation stored in an object of class \code{mids} (from the \code{mice} package).

Unlike with Rubin's regular multiple imputation pooling rules, it is possible
for the pooling rules developed by Raghunathan et al (2003) to give negative
variance estimates. The probability of this occurring is reduced by increasing
\code{M} and/or \code{nSim}.

\code{gFormulaImpute} returns an object of class \code{mids}. This can be analysed using the same
methods that imputed datasets from \code{mice} can be analysed with (see examples). However, Rubin's standard
pooling rules are not valid for analysis of the synthetic datasets. Instead, the synthetic
variance estimator of Raghunathan et al (2003) must be used, as implemented in the
\link{syntheticPool} function.

The development of the \code{gFormulaMI} package was supported by a grant from the UK
Medical Research Council (MR/T023953/1).
}
\examples{
set.seed(7626)
#impute synthetic datasets under two regimes of interest
imps <- gFormulaImpute(data=simDataFullyObs,M=10,
                        trtVars=c("a0","a1","a2"),
                        trtRegimes=list(c(0,0,0),c(1,1,1)))
#fit linear model to final outcome with regime as covariate
fits <- with(imps, lm(y~factor(regime)))
#pool results using Raghunathan et al 2003 rules
syntheticPool(fits)


}
\references{
Bartlett JW, Olarte Parra C, Daniel RM. G-formula for causal inference
via multiple imputation. 2023 \url{https://arxiv.org/abs/2301.12026}

Raghunathan TE, Reiter JP, Rubin DB. 2003. Multiple imputation for statistical
disclosure limitation. Journal of Official Statistics, 19(1), p.1-16.
}
\author{
Jonathan Bartlett \email{jonathan.bartlett1@lshtm.ac.uk}
}
