% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g3Lollipop.R
\name{g3Lollipop}
\alias{g3Lollipop}
\title{G3Lollipop diagram for mutation data}
\usage{
g3Lollipop(mutation.dat, gene.symbol, uniprot.id = NA,
  gene.symbol.col = "Hugo_Symbol", aa.pos.col = "AA_Position",
  protein.change.col = c("Protein_Change", "HGVSp_Short"),
  factor.col = "Mutation_Class", plot.options = list())
}
\arguments{
\item{mutation.dat}{Mutation data frame.}

\item{gene.symbol}{HGNC gene symbol.}

\item{uniprot.id}{UniProt ID, in case that gene symbol maps to multiple UniProt entries.}

\item{gene.symbol.col}{Column name of Hugo gene symbols (e.g., TP53). Default \emph{Hugo_Symbol}.}

\item{aa.pos.col}{Column name of the parsed amino-acid change position. Default \emph{AA_Position}.}

\item{protein.change.col}{Column name of protein change information (e.g., p.K960R, G658S, L14Sfs*15).
Default is a list of \emph{Protein_Change}, \emph{HGVSp_Short}.}

\item{factor.col}{column of classes in the plot legend. IF \code{NA}, use parsed \emph{Mutation_Class} column,
otherwise, use specified.  Default \code{NA}.}

\item{plot.options}{options of lollipop plot in list format}
}
\description{
Generate G3Lollipop chart from the given mutation data.
}
\examples{
\dontrun{
# Example 1: visualize mutation data from cBioPortal
#   note: internet access required, may use more than 10 seconds
mutation.dat <- getMutationsFromCbioportal("msk_impact_2017", "TP53")
# lollipop diagram with default options
g3Lollipop(mutation.dat, gene.symbol = "TP53")
}
# Example 2: visualize mutation data from MAF file
# load MAF file
maf.file <- system.file("extdata", "TCGA.BRCA.varscan.somatic.maf.gz", package = "g3viz")
mutation.dat <- readMAF(maf.file)

# lollipop diagram, classified by "Variant_Classification"
# plot options: add chart title
plot.options <- g3Lollipop.options(
                     chart.margin = list(left = 40, right = 40, top = 30, bottom = 25),
                     title.text = "PIK3CA (TCGA-BRCA)",
                     title.font = "normal 20px Sans",
                     title.color = "steelblue",
                     title.alignment = "middle",
                     title.dy = "0.3em")
g3Lollipop(mutation.dat,
           gene.symbol = "PIK3CA",
           factor.col = "Variant_Classification",
           plot.options = plot.options)

# Example 3: visualize mutation data in CSV or TSV formatted file
# load data
mutation.csv <- system.file("extdata", "ccle.csv", package = "g3viz")

# customized column names
mutation.dat <- readMAF(mutation.csv,
                        gene.symbol.col = "Hugo_Symbol",
                        variant.class.col = "Variant_Classification",
                        protein.change.col = "amino_acid_change",
                        sep = ",")  # separator of csv file

# plot options: try to mimic MutationMapper (http://www.cbioportal.org/mutation_mapper.jsp)
#               change color scheme of mutation track and domain annotation track
plot.options <- g3Lollipop.options(chart.width = 1600,
                                   chart.type = "circle",
                                   lollipop.track.background = "transparent",
                                   lollipop.pop.max.size = 4,
                                   lollipop.pop.min.size = 4,
                                   lollipop.pop.info.limit = 4.1, # same pop size
                                   y.axis.label = "# Mutations",
                                   lollipop.line.color = "grey",
                                   lollipop.line.width = 0.5,
                                   lollipop.circle.color = "black",
                                   lollipop.circle.width = 0.5,
                                   lollipop.color.scheme = "bottlerocket2",
                                   anno.bar.margin = list(top = 5, bottom = 5),
                                   domain.color.scheme = "darjeeling2",
                                   domain.text.font = "normal 8px Arial",
                                   domain.text.color = "white")

g3Lollipop(mutation.dat,
           gene.symbol = "APC",
           protein.change.col = "amino_acid_change",
           plot.options = plot.options)

}
