% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyHeatwaves.R
\name{apply_hw_projections}
\alias{apply_hw_projections}
\title{Apply a function to projected heat waves}
\usage{
apply_hw_projections(hwPath, FUN, city_specific = FALSE, ...)
}
\arguments{
\item{hwPath}{A filepath to a comma-separated (.csv) file with a dataset
of heat waves and their characteristics, as generated by
\code{\link{gen_hw_set}}. The file at the specified filepath must
conform exactly to the format of the heat wave files created by
\code{\link{gen_hw_set}}.}

\item{FUN}{A character string giving the name of a function to apply to
the heat wave dataframe in the file specified by \code{hwPath}.
This function must only take one argument, \code{hw_datafr}, which
identifies a dataframe as generated by \code{\link{gen_hw_set}}. The
function should output a single value (e.g., average heat wave length)
when applied to the full dataframe.}

\item{city_specific}{TRUE or FALSE, specifying whether the function should
be applied separately for each study location.}

\item{...}{Optional arguments to \code{FUN}.}
}
\description{
This function takes a user-specified function and applies is to a
single file of heat wave projections, as specified by \code{hwPath}.
It will generate either a single value for every ensemble member, if
\code{city_specific} is set to \code{FALSE}, or a value for every city, if
\code{city_specific} is set to \code{TRUE}.
}
\note{
The function input as \code{FUN} must follow a very specific
   structure. It most have only one argument, and that argument
   must be a dataframe with heat waves and their characteristics, as
   generated by the \code{\link{gen_hw_set}} function. See the
   \code{futureheatwaves} vignette for more guidance on creating and
   applying a custom function to explore the heat waves identified and
   characterized by \code{\link{gen_hw_set}}.
}

