% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/999.DEPRECATED.R, R/remote.R
\name{transparent}
\alias{transparent}
\alias{remote}
\title{Create a remote future whose value will be resolved asynchronously in a remote process}
\usage{
transparent(...)

remote(
  ...,
  workers = NULL,
  revtunnel = TRUE,
  myip = NULL,
  persistent = TRUE,
  homogeneous = TRUE,
  envir = parent.frame()
)
}
\arguments{
\item{...}{Additional named elements passed to \code{\link[=Future]{Future()}}.}

\item{workers}{A \code{\link[parallel:makeCluster]{cluster}} object,
a character vector of host names, a positive numeric scalar,
or a function.
If a character vector or a numeric scalar, a \code{cluster} object
is created using \code{\link[parallelly:makeClusterPSOCK]{makeClusterPSOCK}(workers)}.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return any of the above types.}

\item{revtunnel}{If TRUE, reverse SSH tunneling is used for the
PSOCK cluster nodes to connect back to the master \R process.  This
avoids the hassle of firewalls, port forwarding and having to know
the internal / public IP address of the master \R session.}

\item{myip}{The external IP address of this machine.
If NULL, then it is inferred using an online service (default).}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{homogeneous}{If TRUE, all cluster nodes is assumed to use the
same path to \file{Rscript} as the main \R session.  If FALSE, the
it is assumed to be on the PATH for each node.
If NULL, then \code{\link[parallelly:makeClusterPSOCK]{parallelly::makeClusterPSOCK()}} will decide on TRUE
or FALSE depending on \code{workers}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{ClusterFuture}.
}
\description{
A remote future is a future that uses remote cluster evaluation,
which means that its \emph{value is computed and resolved
remotely in another process}.
}
\details{
This function is \emph{not} meant to be called directly.  Instead, the
typical usages are:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Evaluate futures on remote machine 'server.example.org', and
# any nested ones sequentially (default) on that remote machine
plan(remote, workers = "server.example.org")

# Evaluate futures on remote machine 'server.example.org', and
# nested ones in parallel on that remote machine
plan(list(
   tweak(remote, workers = "server.example.org"),
   multisession
))

# Evaluate futures on remote machine 'server.example.org', and
# nested ones in parallel on the remote machines n1, n2, and n3.
plan(list(
  tweak(remote, workers = "server.example.org"),
  tweak(cluster, workers = c("n1", "n2", "n3"))
))
}\if{html}{\out{</div>}}
}
\section{'remote' versus 'cluster'}{

The \code{remote} plan is a very similar to the \code{\link{cluster}} plan, but provides
more convenient default argument values when connecting to remote machines.
Specifically, \code{remote} uses \code{persistent = TRUE} by default, and it sets
\code{homogeneous}, \code{revtunnel}, and \code{myip} "wisely" depending on the value of
\code{workers}.
' See below for example on how \code{remote} and \code{cluster} are related.
}

\examples{
\dontrun{\donttest{

## DEFUNCT: 'remote' is defunct in favor of 'cluster' with
## persistent = TRUE.  Note however, that argument 'persistent'
## will eventually be deprecated too when there is an alternative
## for users and developers to handle "sticky" globals

## Use a remote machine
plan(cluster, workers = "remote.server.org", persistent = TRUE)

## Evaluate expression remotely
host \%<-\% { Sys.info()[["nodename"]] }
host
[1] "remote.server.org"


## The following setups are equivalent:
plan(remote, workers = "localhost")  ## DEFUNCT in future (>= 1.30.0)
plan(cluster, workers = "localhost", persistent = TRUE)
plan(cluster, workers = 1, persistent = TRUE)

## The following setups are equivalent:
plan(remote, workers = "remote.server.org")  ## DEFUNCT in future (>= 1.30.0)
plan(cluster, workers = "remote.server.org", persistent = TRUE, homogeneous = FALSE)

## The following setups are equivalent:
cl <- makeClusterPSOCK("remote.server.org")
plan(remote, workers = cl)  ## DEFUNCT in future (>= 1.30.0)
plan(cluster, workers = cl, persistent = TRUE)

}}
}
\keyword{internal}
