% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicore.R
\name{multicore}
\alias{multicore}
\title{Create a multicore future whose value will be resolved asynchronously in a forked parallel process}
\usage{
multicore(
  ...,
  workers = availableCores(constraints = "multicore"),
  envir = parent.frame()
)
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[=Future]{Future()}}.}

\item{workers}{A positive numeric scalar or a function specifying the
maximum number of parallel futures that can be active at the same time
before blocking.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return a numeric scalar.}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{MulticoreFuture}
If \code{workers == 1}, then all processing using done in the
current/main \R session and we therefore fall back to using
an sequential future.  This is also the case whenever multicore
processing is not supported, e.g. on Windows.
}
\description{
A multicore future is a future that uses multicore evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function will block if all cores are occupied and
will be unblocked as soon as one of the already running
multicore futures is resolved.  For the total number of
cores available including the current/main \R process, see
\code{\link[=availableCores]{availableCores()}}.

Not all operating systems support process forking and thereby not multicore
futures.  For instance, forking is not supported on Microsoft Windows.
Moreover, process forking may break some R environments such as RStudio.
Because of this, the future package disables process forking also in
such cases.  See \code{\link[=supportsMulticore]{supportsMulticore()}} for details.
Trying to create multicore futures on non-supported systems or when
forking is disabled will result in multicore futures falling back to
becoming \link{sequential} futures.

The preferred way to create an multicore future is not to call
this function directly, but to register it via
\code{\link{plan}(multicore)} such that it becomes the default
mechanism for all futures.  After this \code{\link[=future]{future()}}
and \code{\link{\%<-\%}} will create \emph{multicore futures}.
}
\examples{
## Use multicore futures
plan(multicore)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multicore future is evaluated in a separate forked
## process.  Changing the value of a global variable
## will not affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}
\seealso{
For processing in multiple background \R sessions, see
\link{multisession} futures.

Use \code{\link[=availableCores]{availableCores()}} to see the total number of
cores that are available for the current \R session.
Use \code{\link{availableCores}("multicore") > 1L} to check
whether multicore futures are supported or not on the current
system.
}
