% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/values.R
\name{values}
\alias{values}
\alias{value.list}
\alias{value.environment}
\alias{value.listenv}
\title{Get all values in a container}
\usage{
values(x, stdout = TRUE, signal = TRUE, ...)
}
\arguments{
\item{x}{A \link{Future}, an environment, a list, or a list environment.}

\item{stdout}{If TRUE, captured standard output is relayed, otherwise note.}

\item{signal}{If TRUE, captured (\link[base]{conditions}) are relayed,
otherwise not.}

\item{\dots}{Additional arguments passed to \code{value()} of each future.}
}
\value{
An object of same type as \code{x} and with the same names
and/or dimensions, if set.
If \code{signal} is TRUE and one of the futures produces an error, then
that error is produced.
}
\description{
Gets all values in an environment, a list, or a list environment
and returns an object of the same class (and dimensions).
All future elements are replaced by their corresponding
\code{value()} values.  For all other elements, the existing
object is kept.
}
