% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{remote}
\alias{remote}
\title{Create a remote future whose value will be resolved asynchroneously in a remote process}
\usage{
remote(expr, envir = parent.frame(), substitute = TRUE, persistent = TRUE,
  workers = NULL, gc = FALSE, earlySignal = FALSE, myip = NULL, ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done and from which globals are obtained.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{workers}{A cluster object created by
\code{\link[parallel]{makeCluster}()}.}

\item{gc}{If TRUE, the garbage collector run after the future
is resolved (in the process that evaluated the future).}

\item{earlySignal}{Specified whether conditions should be signaled as soon as possible or not.}

\item{myip}{The external IP address of this machine.
If NULL, then it is inferred using an online service (default).}

\item{\dots}{Not used.}
}
\value{
A \link{ClusterFuture}.
}
\description{
A remote future is a future that uses remote cluster evaluation,
which means that its \emph{value is computed and resolved
remotely in another process}.
}
\details{
Note that remote futures use \code{persistent=TRUE} by default.
}
\examples{
\dontrun{\donttest{

## Use a remote machine
plan(remote, workers="remote.server.org")

## Evaluate expression remotely
host \%<-\% { Sys.info()[["nodename"]] }
host
[1] "remote.server.org"

}}
}

