% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plan.R
\name{plan}
\alias{plan}
\title{Plan how to resolve a future}
\usage{
plan(strategy = NULL, ..., substitute = TRUE, .call = sys.call())
}
\arguments{
\item{strategy}{The evaluation function to use for resolving a future.
If NULL, then the current strategy is returned.}

\item{...}{Additional arguments overriding the default arguments
of the evaluation function.}

\item{substitute}{If TRUE, the \code{strategy} expression is
\code{substitute()}:d, otherwise not.}

\item{.call}{(internal) Used to record the call to this function.}
}
\value{
If a new strategy is choosen, then the previous one is returned
(invisible), otherwise the current one is returned (visibly).
}
\description{
This function allows you to plan the future, more specifically,
it specifies how \code{\link{future}()}:s are resolved,
e.g. by eager or by lazy evaluation.
}
\examples{
a <- b <- c <- NA_real_

# A lazy future (evaluated in a local environment)
plan(lazy)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## All NAs


# An eager future (evaluated in a local environment)
plan(eager)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## All NAs


# A multicore future evaluated in a local environment
plan(multicore)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## All NAs


# An eager future evaluated in the global environment
plan(eager, local=FALSE)
f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})
y <- value(f)
print(y)
str(list(a=a, b=b, c=c)) ## Assigned the new values
}
\seealso{
Evaluation functions provided by this package are \code{\link{eager}()},
\code{\link{lazy}()} and \code{\link{multicore}()}.
Other package may provide additional evaluation strategies/functions.
}

