% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_template.R
\name{batchtools_template}
\alias{batchtools_template}
\alias{batchtools_lsf}
\alias{batchtools_openlava}
\alias{batchtools_sge}
\alias{batchtools_slurm}
\alias{batchtools_torque}
\title{Batchtools futures for LSF, OpenLava, SGE, Slurm, TORQUE etc.}
\usage{
batchtools_lsf(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  template = NULL,
  resources = list(),
  workers = NULL,
  registry = list(),
  ...
)

batchtools_openlava(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  template = NULL,
  resources = list(),
  workers = NULL,
  registry = list(),
  ...
)

batchtools_sge(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  template = NULL,
  resources = list(),
  workers = NULL,
  registry = list(),
  ...
)

batchtools_slurm(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  template = NULL,
  resources = list(),
  workers = NULL,
  registry = list(),
  ...
)

batchtools_torque(
  expr,
  envir = parent.frame(),
  substitute = TRUE,
  globals = TRUE,
  label = NULL,
  template = NULL,
  resources = list(),
  workers = NULL,
  registry = list(),
  ...
)
}
\arguments{
\item{expr}{The R expression to be evaluated}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or a
\link[globals:Globals]{Globals} object.  If TRUE, globals are identified by code
inspection based on \code{expr} and \code{tweak} searching from environment
\code{envir}.  If FALSE, no globals are used.  If a character vector, then
globals are identified by lookup based their names \code{globals} searching
from environment \code{envir}.  If a named list or a Globals object, the
globals are used as is.}

\item{label}{(optional) Label of the future (where applicable, becomes the
job name for most job schedulers).}

\item{template}{(optional) A batchtools template file or a template string
(in \pkg{brew} format).  If not specified, it is left to the
\pkg{batchtools} package to locate such file using its search rules.}

\item{resources}{(optional) A named list passed to the \pkg{batchtools}
template (available as variable \code{resources}).  See Section 'Resources'
in \code{\link[batchtools:submitJobs]{batchtools::submitJobs()}} more details.}

\item{workers}{(optional) The maximum number of workers the batchtools
backend may use at any time.   Interactive and "local" backends can only
process one future at the time (\code{workers = 1L}), whereas HPC backends,
where futures are resolved via separate jobs on a scheduler, can have
multiple workers.  In the latter, the default is \code{workers = NULL}, which
will resolve to \code{getOption("future.batchtools.workers")}.  If neither
are specified, then the default is \code{100}.}

\item{registry}{(optional) A named list of settings to control the setup
of the batchtools registry.}

\item{\ldots}{Additional arguments passed to \code{\link[=BatchtoolsFuture]{BatchtoolsFuture()}}.}
}
\value{
An object of class \code{BatchtoolsFuture}.
}
\description{
Batchtools futures for LSF, OpenLava, SGE, Slurm, TORQUE etc. are
asynchronous multiprocess futures that will be evaluated on a compute
cluster via a job scheduler.
}
\details{
These type of batchtools futures rely on batchtools backends set
up using the following \pkg{batchtools} functions:
\itemize{
\item \code{\link[batchtools:makeClusterFunctionsLSF]{batchtools::makeClusterFunctionsLSF()}} for
\href{https://en.wikipedia.org/wiki/Platform_LSF}{Load Sharing Facility (LSF)}
\item \code{\link[batchtools:makeClusterFunctionsOpenLava]{batchtools::makeClusterFunctionsOpenLava()}} for
\href{https://en.wikipedia.org/wiki/OpenLava}{OpenLava}
\item \code{\link[batchtools:makeClusterFunctionsSGE]{batchtools::makeClusterFunctionsSGE()}} for
\href{https://en.wikipedia.org/wiki/Oracle_Grid_Engine}{Sun/Oracle Grid Engine (SGE)}
\item \code{\link[batchtools:makeClusterFunctionsSlurm]{batchtools::makeClusterFunctionsSlurm()}} for
\href{https://en.wikipedia.org/wiki/Slurm_Workload_Manager}{Slurm}
\item \code{\link[batchtools:makeClusterFunctionsTORQUE]{batchtools::makeClusterFunctionsTORQUE()}} for
\href{https://en.wikipedia.org/wiki/TORQUE}{TORQUE} / PBS
}
}
