# WARNING - Generated by {fusen} from /dev/flat_package.Rmd: do not edit by hand

test_that("simul_traj", {
    # test ok
    simu_vec <- simul_traj(100)
    expect_equal(length(simu_vec), 100)
    checkmate::qexpect(simu_vec, "N100")
    
    # warning
    n_point = 10
    distrib = "normal"
    max_iter = 1
    expect_warning(simul_traj(n_point, distrib, max_iter))
})

test_that("simul_data", {
    n_point <- 100
    n_obs1 <- 50
    n_obs2 <- 75
    c_val <- 0
    delta_shape = "constant" 
    distrib = "normal"
    max_iter = 10000
    simu_data <- simul_data(n_point, n_obs1, n_obs2, c_val, delta_shape, 
        distrib, max_iter)
    checkmate::expect_list(simu_data, len = 5)
    expect_equal(
        names(simu_data), 
        c("mat_sample1", "mat_sample2", "c_val", "distrib", "delta_shape")
    )
    expect_true(is.numeric(simu_data$mat_sample1))
    expect_equal(dim(simu_data$mat_sample1), c(n_point, n_obs1))
    expect_true(is.numeric(simu_data$mat_sample2))
    expect_equal(dim(simu_data$mat_sample2), c(n_point, n_obs2))
})

test_that("plot_simu", {
    set.seed(1234)
    simu_data <- simul_data(
        n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 10, 
        delta_shape = "constant", distrib = "normal"
    )
    vdiffr::expect_doppelganger(
        "plot_simu", plot_simu(simu_data))
})
