% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_fgpm_Class.R
\docType{class}
\name{fgpm-class}
\alias{fgpm-class}
\title{S4 class for funGp Gaussian process models}
\description{
This is the formal representation of Gaussian process models within the
  \link[=funGp-package]{funGp package}. Gaussian process models are useful statistical tools in the
  modeling of complex input-output relationships.
\itemize{
 \item{\strong{Main methods}}{\cr
       \link[funGp]{fgpm}: creation of funGp regression models \cr
       \link[funGp]{predict}: output estimation at new input points based on a funGp model \cr
       \link[funGp]{simulate}: random sampling from a funGp Gaussian process model \cr
       \link[funGp]{update}: modification of data and hyperparameters of a funGp model
 }
 \item{\strong{Plotters}}{\cr
       \link[funGp]{plotLOO}: leave-one-out diagnostic plot for a funGp model \cr
       \link[funGp]{plotPreds}: plot for predictions of a funGp model \cr
       \link[funGp]{plotSims}: plot for simulations of a funGp model
 }
}
}
\section{Slots}{

\describe{
\item{\code{howCalled}}{Object of class \code{"\linkS4class{modelCall}"}. User call reminder.}

\item{\code{type}}{Object of class \code{"character"}. Type of model based on type of inputs. To be set from
{"scalar", "functional", "hybrid"}.}

\item{\code{ds}}{Object of class \code{"numeric"}. Number of scalar inputs.}

\item{\code{df}}{Object of class \code{"numeric"}. Number of functional inputs.}

\item{\code{f_dims}}{Object of class \code{"numeric"}. An array with the original dimension of each functional
input.}

\item{\code{sIn}}{Object of class \code{"matrix"}. The scalar input points. Variables are arranged by columns and
coordinates by rows.}

\item{\code{fIn}}{Object of class \code{"list"}. The functional input points. Each element of the list contains
a functional input in the form of a matrix. In each matrix, curves representing functional coordinates
are arranged by rows.}

\item{\code{sOut}}{Object of class \code{"matrix"}. The scalar output values at the coordinates specified by sIn
and/or fIn.}

\item{\code{n.tot}}{Object of class \code{"integer"}. Number of observed points used to compute the training-training
and training-prediction covariance matrices.}

\item{\code{n.tr}}{Object of class \code{"integer"}. Among all the points loaded in the model, the amount used for
training.}

\item{\code{f_proj}}{Object of class \code{"fgpProj"}. Data structures related to the projection of functional
inputs. Check \linkS4class{fgpProj} for more details.}

\item{\code{kern}}{Object of class \code{"fgpKern"}. Data structures related to the kernel of the Gaussian process
model. Check \linkS4class{fgpKern} for more details.}

\item{\code{nugget}}{Object of class \code{"numeric"}. Variance parameter standing for the homogeneous nugget effect.}

\item{\code{preMats}}{Object of class \code{"list"}. L and LInvY matrices pre-computed for prediction. L is a lower
diagonal matrix such that \eqn{L'L} equals the training auto-covariance matrix \eqn{K.tt}. On the other
hand, \eqn{LInvY = L^(-1) * sOut}.}
}}

\section{Useful material}{

\itemize{
 \item{\strong{Manual}}{
 \href{https://hal.archives-ouvertes.fr/hal-02536624}{
 Gaussian Process Regression for Scalar and Functional Inputs with funGp - The in-depth tour
 }}
}
}

\author{
José Betancourt, François Bachoc and Thierry Klein
}
