% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctions.R
\name{decay2probs}
\alias{decay2probs}
\title{Probability functions for ant colony optimization in funGp}
\usage{
decay2probs(
  k,
  pmax = NULL,
  tao0 = 0.1,
  delta = 2,
  dispr = 1.4,
  doplot = TRUE,
  deliver = FALSE
)
}
\arguments{
\item{k}{a number indicating the dimension of the functional input under analysis.}

\item{pmax}{an optional number specifying the hypothetical maximum projection dimension of this input. The
user will be able to set this value later in the call to \link[funGp]{fgpm_factory} as a constraint. If
not specified, it takes the value of k.}

\item{tao0}{explained in the description of \emph{dispr}.}

\item{delta}{explained in the description of \emph{dispr}.}

\item{dispr}{the arguments \emph{tao0}, \emph{delta} and \emph{dispr}, are optional numbers specifying the
  loss function that determines the initial pheromone load on the links pointing out to projection
  dimensions. Such a function is defined as

  \deqn{tao = tao0 * exp(-.5 * ((p - delta - 1)^2/(-dispr^2/(2*log(.5)),}

  with p taking the values of the projection dimensions. The argument \emph{tao0} indicates the pheromone
  load in the links pointing out to the smallest dimensions; \emph{delta} specifies how many dimensions
  should preserve the maximum pheromone load; \emph{dispr} determines how fast the pheromone load drops
  in dimensions further than \eqn{delta + 1}. If \emph{pmax} = \emph{k}, then the dimension 0,
  representing no projection, receives a pheromone load identical to that of dimension \emph{k}. This, in
  order to represent the fact that both, the representation of the function in its original dimension or
  a projection in a space of the same dimension, are equally heavy for the model. In order to obtain the
  probability loads, the initial pheromone values are normalized to sum 1. Note that the normalization
  makes the value of tao0 become irrelevant in the initial probability load. This does not mean that the
  effect of tao0 is completely removed from the algorithm. Despite the fact that tao0 does not have
  influence on the selection of the projection dimension during the first iteration, it will be
  protagonist during the global pheromone update and will have an impact on every further iteration.
  The argument tao0 is left active in the input just for a better comprehension of the functioning of the
  mechanisms defining the initial pheromone and probability loads. The default values of
  \emph{tao0}, \emph{delta} and \emph{dispr}, are 0.1, 2 and 1.4, respectively, which match the default
  values used by the \link[funGp]{fgpm_factory} function. Check
  \href{https://hal.archives-ouvertes.fr/hal-02532713}{this technical
  report} for more details.}

\item{doplot}{an optional boolean indicating if the probability loads should be plotted. Default = TRUE.}

\item{deliver}{an optional boolean indicating if the probability loads should be returned. Default = FALSE.}
}
\value{
If deliver is TRUE, an object of class \code{"numeric"} containing the normalized initial pheromone values
  corresponding to the specified projection dimensions. Otherwise, the function plots the normalized
  pheromones and nothing is returned.
}
\description{
This function is intended to aid the selection of the heuristic parameters \emph{tao0},
  \emph{delta} and \emph{dispr} in the call to the model selection function \link[funGp]{fgpm_factory}.
  The values computed by decay2probs are the ones that would be used by the ant colony algorithm as
  probability load of the links pointing out to projection on each dimension. These values result from
  the normalization of the initial pheromone loads delivered by the \link[funGp]{decay} function, which
  are made to sum 1. For more details, check the
  \href{https://hal.archives-ouvertes.fr/hal-02532713}{technical report}
  explaining the ant colony algorithm implemented in funGp, and the
  \href{https://hal.archives-ouvertes.fr/hal-02536624}{
  manual} of the package.
}
\examples{
# using default decay arguments____________________________________________________________
# input of dimension 15 projected maximum in dimension 15
decay(15) # initial pheromone load
decay2probs(15) # initial probability load

# input of dimension 15 projected maximum in dimension 8
decay(15, 8) # initial pheromone load
decay2probs(15, 8) # initial probability load


# playing with decay2probs arguments_______________________________________________________
# varying the initial pheromone load
decay(15) # input of dimension 15 projected maximum in dimension 15
decay(15, tao0 = .3) # larger value of tao0
decay(15, tao0 = .3, delta = 5) # larger tao0 kept to higher dimensions
decay(15, tao0 = .3, delta = 5, dispr = 5.2) # larger tao0 kept to higher dimensions
                                             # and slower decay

# varying the initial probability load
decay2probs(15) # input of dimension 15 projected maximum in dimension 15
decay2probs(15, tao0 = .3) # larger value of tao0 (no effect whatsoever)
decay2probs(15, tao0 = .3, delta = 5) # larger tao0 kept to higher dimensions
decay2probs(15, tao0 = .3, delta = 5, dispr = 5.2) # larger tao0 kept to higher dimensions
                                                   # and slower decay


# requesting probability values____________________________________________________________
# input of dimension 15 projected maximum in dimension 15
decay2probs(15, deliver = TRUE)

}
\seealso{
\strong{*} \link[funGp]{decay} for the function to generate the initial pheromone load;

\strong{*} \link[funGp]{fgpm_factory} for heuristic model selection in funGp.
}
\author{
José Betancourt, François Bachoc and Thierry Klein
}
