% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_table.R
\name{ft_table}
\alias{ft_table}
\title{Collect metadata and text into a data.frame}
\usage{
ft_table(path = NULL, type = NULL, encoding = NULL, xml_extract_text = TRUE)
}
\arguments{
\item{path}{a directory path, must exist}

\item{type}{(character) type of files to get. Default is \code{NULL} which gets all types.
Can be one of pdf, xml, or plain (file extensions: pdf, xml, and txt, respectively)}

\item{encoding}{(character) encoding, if \code{NULL} we get it from \code{getOption("encoding")}}

\item{xml_extract_text}{(logical) for XML, should we extract the text (\code{TRUE}) or
return a string as XML (\code{FALSE}). Default: \code{TRUE}}
}
\description{
Facilitates downstream processing with text mining packages
by providing metadata and full text in a tidy data.frame format
}
\details{
You can alternatively use \code{readtext::readtext()} or similar functions
to achieve a similar outcome.
}
\examples{
 
\dontrun{
## from a directory path
x <- ft_table()
x

## only xml
ft_table(type = "xml")

## only pdf
ft_table(type = "pdf")

## don't pull text out of xml, just give back the xml please
x <- ft_table(xml_extract_text = FALSE)
x
}
}
