% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\alias{cache_options_set}
\alias{cache_options_get}
\title{Set or get cache options}
\usage{
cache_options_set(path = "fulltext", backend = "ext",
  overwrite = FALSE, full_path = NULL)

cache_options_get()
}
\arguments{
\item{path}{(character) End of directory path. Default: "fulltext".
See Details.}

\item{backend}{(character) Only "ext" supported for now.}

\item{overwrite}{(logical) overwrite cached file or not. Default: \code{FALSE}}

\item{full_path}{(character) Full cache path. If given \code{path} is ignored.}
}
\value{
both functions return the cache options in a named list
}
\description{
Set or get cache options
}
\section{Managing cached files}{

The dafault cache directory is \code{paste0(rappdirs::user_cache_dir(), "/R/fulltext")},
but you can set your own path using \code{cache_path_set()}

You can alternatively set the entire cache path with the \code{full_path}
parameter.

You can only pass \code{path} or \code{full_path} - but not both.

\code{cache_delete} only accepts 1 file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}}
type call
}

\examples{
\dontrun{
cache_options_get()
cache_options_set(path = "foobar")
cache_options_get()

# set full path
path <- tempdir()
cache_options_set(full_path = path)
cache_options_get()
}
}
\seealso{
\link{ftxt_cache}, \code{\link[=cache_file_info]{cache_file_info()}}

Other caching-functions: \code{\link{cache_file_info}},
  \code{\link{ftxt_cache}}
}
\concept{caching-functions}
