% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.ft_data.R
\name{as.ft_data}
\alias{as.ft_data}
\title{Coerce directory of papers to ft_data object}
\usage{
as.ft_data(path = NULL)
}
\arguments{
\item{path}{cache path. if not given, we use the default
cache path. Default: \code{NULL}}
}
\value{
an object of class \code{ft_data}
}
\description{
create the same object that \code{\link[=ft_get]{ft_get()}} outputs
from your cached files - without having to run
\code{\link[=ft_get]{ft_get()}} again
}
\details{
We use an internal store of identifiers to keep track of files.
These identifiers are in the output of \code{\link[=ft_get]{ft_get()}} and you can see them
in that output.  If a file does not have a matching entry in our index
of files (e.g., if you drop a file into the cache location as in the
example below), then we assign it an index based on the file path; we'd
ideally use an article DOI or similar but we can not safely retrieve it
with just a file path.
}
\examples{
# put a file in the cache in case there aren't any
dir <- file.path(tempdir(), "testing")
dir.create(dir)
file <- system.file("examples/elife.xml", package = "fulltext")
writeLines(readLines(file), tempfile(tmpdir = dir, fileext = ".xml"))

# call as.ft_data
x <- as.ft_data(path = dir)

# output lives underneath a special list index "cached" 
#   representing already present files
x$cached

# collect chunks
# x \%>\% ft_collect \%>\% ft_chunks(c("doi", "title"))
}
\seealso{
\code{\link[=ft_get]{ft_get()}}
}
