% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip.R
\name{flip}
\alias{flip}
\alias{flip.default}
\alias{flip.matrix}
\alias{flip.data.frame}
\title{Flip}
\usage{
flip(x, ...)

\method{flip}{default}(x, ...)

\method{flip}{matrix}(x, by = c("rows", "columns"), keep_rownames = NULL, ...)

\method{flip}{data.frame}(x, by = c("rows", "columns"), keep_rownames = NULL, ...)
}
\arguments{
\item{x}{An object}

\item{...}{Additional arguments passed to methods}

\item{by}{Flip by \code{"rows"} or \code{"columns"} (partial matches accepted)}

\item{keep_rownames}{Logical, if \code{TRUE} will not reset row names; \code{NULL}}
}
\value{
A \code{vector} of values, equal length of \code{x} that is reversed or a
\verb{data frame} with flipped rows/columns
}
\description{
Flip an object.
}
\examples{
flip(letters[1:3])
flip(seq.int(9, -9, by = -3))
flip(head(iris))
flip(head(iris), keep_rownames = TRUE)
flip(head(iris), by = "col")

}
