% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/susan.R
\name{susan}
\alias{susan}
\title{FSL SUSAN noise reduction}
\usage{
susan(file, outfile = NULL, retimg = TRUE, reorient = FALSE,
  intern = FALSE, bthresh = 0.1, sigma = 3, dimg = c(3, 2),
  use_median = FALSE, n_usans = c(0, 1, 2), extra.scans = list(),
  opts = "", verbose = TRUE, ...)
}
\arguments{
\item{file}{(character) image to be manipulated}

\item{outfile}{(character) resultant image name (optional)}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readNIfTI}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{bthresh}{brightness threshold and should be greater than noise level and less than contrast of edges to be preserved.}

\item{sigma}{spatial size (sigma i.e. half-width) of smoothing in mm.}

\item{dimg}{dimensionality (2 or 3) depending on whether smoothing is to be within-plane (2) or fully 3D (3).}

\item{use_median}{determines whether to use a local median filter in the cases where single-point noise is detected (0 or 1).}

\item{n_usans}{determines whether the smoothing area (USAN) is to be found from secondary images (0 1 or 2).}

\item{extra.scans}{List of extra scans for USAN.  List of
\code{n_usans} elements, where each element has 2 named objects
\code{bthresh} and \code{filename}}

\item{opts}{(character) operations to be passed to \code{susan}, not
currently used.}

\item{verbose}{(logical) print out command before running}

\item{...}{additional arguments passed to \code{\link{fslcmd}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
Implements Smallest Univalue Segment Assimilating Nucleus
(SUSAN) noise reduction technique from FSL
}
\references{
S.M. Smith and J.M. Brady. SUSAN -a new approach to low level image processing.
International Journal of Computer Vision, 23(1):45-78, May 1997.
}

