% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{delete}
\alias{delete}
\alias{file_delete}
\alias{dir_delete}
\alias{link_delete}
\title{Delete files, directories, or links}
\usage{
file_delete(path)

dir_delete(path)

link_delete(path)
}
\arguments{
\item{path}{A character vector of one or more paths.}
}
\value{
The deleted paths (invisibly).
}
\description{
\code{file_delete()} and \code{link_delete()} delete file and links. Compared to
\link{file.remove} they always fail if they cannot delete the object rather than
changing return value or signalling a warning.

\code{dir_delete()} will first delete the contents of the directory, then remove
the directory. Compared to \link{unlink} it will always throw an error if the
directory cannot be deleted rather than being silent or signalling a warning.
}
\examples{
\dontshow{fs:::pkgdown_tmp("/tmp/filedd4635bd7c86")}
# create a directory, with some files and a link to it
dir <- dir_create(file_temp())
files <- file_create(path(dir, letters[1:5]))
link <- link_create(path_abs(dir), "link")

# All files created
dir_exists(dir)
file_exists(files)
link_exists(link)
file_exists(link_path(link))

# Delete a file
file_delete(files[1])
file_exists(files[1])

# Delete the directory (which deletes the files as well)
dir_delete(dir)
file_exists(files)
dir_exists(dir)

# The link still exists, but what it points to does not.
link_exists(link)
dir_exists(link_path(link))

# Delete the link
link_delete(link)
link_exists(link)
}
