% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_centsums.R
\name{as.centcosums}
\alias{as.centcosums}
\alias{as.centcosums.default}
\title{Coerce to a centcosums object.}
\usage{
as.centcosums(x, order=2, na.omit=TRUE)

\method{as.centcosums}{default}(x, order = 2, na.omit = TRUE)
}
\arguments{
\item{x}{a matrix.}

\item{order}{the order, defaulting to \code{2}.}

\item{na.omit}{whether to remove rows with \code{NA}.}
}
\value{
A centcosums object.
}
\description{
Convert data to a \code{centcosums} object.
}
\details{
Computes the raw cosums on data, and stuffs the results into a 
\code{centcosums} object.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
set.seed(123)
x <- matrix(rnorm(100*3),ncol=3)
cs <- as.centcosums(x, order=2)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
