% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_rows.R
\name{search_rows}
\alias{search_rows}
\title{Search All Rows Across Columns of a Matrix-like Structure}
\usage{
search_rows(x, pattern = ".*", include_row_names = TRUE)
}
\arguments{
\item{x}{A \code{\link{matrix}} or \code{\link{data.frame}}.}

\item{pattern}{A pattern.}

\item{include_row_names}{Include row names into the search?}
}
\value{
All rows where the pattern was found in at least one column.
}
\description{
I sometimes need to see which rows of a matrix-like structure
contain a string matched by a search pattern.
This somewhat similar to writing a matrix-like structure to disk and then
using \code{\link{search_files}} on it.
}
\examples{
p <- "\\\\<4.0[[:alpha:]]*\\\\>"
search_rows(x = mtcars, pattern = p)
search_rows(x = mtcars, pattern = p, include_row_names = FALSE)
try(search_rows(x = mtcars, pattern = "ABC"))
}
\seealso{
Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{fromto}()},
\code{\link{grep_file}()},
\code{\link{missing_docs}},
\code{\link{runsed}()},
\code{\link{search_files}()},
\code{\link{summary.filesearch}()}
}
\concept{searching functions}
