#' Mock the Unix \command{touch} utility
#'
#' Creating a file or ensuring a file's modification time changes.
#'
#' @param path Path to the file to be touched.
#' @return The Path to the file touched.
#' @export
#' @examples
#' file <- tempfile()
#' touch(file)
#' t1 <- file.mtime(file)
#' touch(file)
#' t2 <- file.mtime(file)
#' t1 < t2
touch <- function(path) {
    if (!file.exists(path)) {
        cat("# This file was generated by touch()", file = path)
    } else {
        tmp <- tempfile()
        on.exit(unlink(tmp))
        file.copy(path, tmp)
        if (file.mtime(tmp) <= file.mtime(path)) Sys.sleep(2)
        file.copy(tmp, path, overwrite = TRUE)
    }
    return(invisible(path))
}
