% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_internal_functions.R
\name{load_internal_functions}
\alias{load_internal_functions}
\title{Load a Package's Internals}
\usage{
load_internal_functions(package, ...)
}
\arguments{
\item{package}{The name of the package as a string.}

\item{...}{Arguments passed to \code{\link{ls}}, all.names = TRUE could be a
good idea.}
}
\value{
invisible(TRUE)
}
\description{
Load objects not exported from a package's namespace.
}
\details{
The files to be checked get sourced, which means they have to contain R code
producing no errors. If we want to check the source code of a package, we
need to load the package \emph{and} be able to run all its internals in our
environment.
}
\examples{
load_internal_functions("fritools")
}
\seealso{
\code{\link[codetools:checkUsageEnv]{checkUsageEnv in codetools}}.
}
