% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is-output-same.R
\name{is.output.same}
\alias{is.output.same}
\title{Checks if functions will produce identical output}
\usage{
is.output.same(.call, ..., quiet = FALSE)
}
\arguments{
\item{.call}{Function call, such as ".call = my_function(x = 1:3)"}

\item{...}{One or more function names}

\item{quiet}{Optional warning suppression}
}
\value{
logical - TRUE if outputs are identical
}
\description{
The use for this is to evaluate your code while you're cleaning your functions. You
can have a function call as the first argument and the name of another function as
the second argument, then it will evaluate the functions with the arguments of the
call and see if the output is identical.
}
\details{
Use only in pipe chains with a length of one, or it will use the code at the
 top of the pipe-chain. Also it's not recommended to use pipes with this function, as
 it undoes the evaluation of prior code in the pipe. If you don't pipe in .call, then
 the function operates off the fact that a call given as an argument is treated as a
 promise, allowing the code to be wrapped in substitute() inside the function.
}
\examples{

is.output.same(purrr::map(1:3, cumsum), lapply) # TRUE
is.output.same(cumsum(1:3), cumprod)     # FALSE
is.output.same(sum(1:3), prod)           # FALSE for outputs of different class
is.output.same(mean(1:3), prod)          # FALSE

}
\seealso{
\code{\link{find_call_piped}}
}
