% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_package.R
\name{write_package}
\alias{write_package}
\title{Write a Data Package to disk}
\usage{
write_package(package, directory, compress = FALSE)
}
\arguments{
\item{package}{Data Package object, as returned by \code{\link[=read_package]{read_package()}} or
\code{\link[=create_package]{create_package()}}.}

\item{directory}{Path to local directory to write files to.}

\item{compress}{If \code{TRUE}, data of added resources will be gzip compressed
before being written to disk (e.g. \code{deployments.csv.gz}).}
}
\value{
\code{package} invisibly, as written to file.
}
\description{
Writes a Data Package and its related Data Resources to disk as a
\code{datapackage.json} and CSV files.
Already existing CSV files of the same name will not be overwritten.
The function can also be used to download a Data Package in its entirety.
The Data Resources are handled as follows:
\itemize{
\item Resource \code{path} has at least one local path (e.g. \code{deployments.csv}):
CSV files are copied or downloaded to \code{directory} and \code{path} points to new
location of file(s).
\item Resource \code{path} has only URL(s): resource stays as is.
\item Resource has inline \code{data} originally: resource stays as is.
\item Resource has inline \code{data} as result of adding data with \code{\link[=add_resource]{add_resource()}}:
data are written to a CSV file using \code{\link[readr:write_delim]{readr::write_csv()}}, \code{path} points to
location of file, \code{data} property is removed.
Use \code{compress = TRUE} to gzip those CSV files.
}
}
\examples{
# Load the example Data Package from disk
package <- read_package(
  system.file("extdata", "datapackage.json", package = "frictionless")
)

package

# Write the (unchanged) Data Package to disk
write_package(package, directory = "my_directory")

# Check files
list.files("my_directory")

# No files written for the "observations" resource, since those are all URLs.
# No files written for the "media" resource, since it has inline data.

# Clean up (don't do this if you want to keep your files)
unlink("my_directory", recursive = TRUE)
}
\concept{write functions}
