% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_resource.R
\name{add_resource}
\alias{add_resource}
\title{Add a Data Resource}
\usage{
add_resource(package, resource_name, data, schema = NULL, delim = ",")
}
\arguments{
\item{package}{List describing a Data Package, created with \code{\link[=read_package]{read_package()}}
or \code{\link[=create_package]{create_package()}}.}

\item{resource_name}{Name of the Data Resource.}

\item{data}{Data to attach, either a data frame or path(s) to CSV file(s):
\itemize{
\item Data frame: attached to the resource as \code{data} and written to a CSV file
when using \code{\link[=write_package]{write_package()}}.
\item One or more paths to CSV file(s) as a character (vector): added to the
resource as \code{path}.
The \strong{last file will be read} with \code{\link[readr:read_delim]{readr::read_delim()}} to create or
compare with \code{schema} and to set \code{format}, \code{mediatype} and \code{encoding}.
The other files are ignored, but are expected to have the same structure
and properties.
}}

\item{schema}{Either a list, or path or URL to a JSON file describing a Table
Schema for the \code{data}.
If not provided, one will be created using \code{\link[=create_schema]{create_schema()}}.}

\item{delim}{Single character used to separate the fields in the CSV file(s),
e.g. \verb{\\t} for tab delimited file.
Will be set as \code{delimiter} in the resource \href{https://specs.frictionlessdata.io/csv-dialect/#specification}{CSV dialect}, so
read functions know how to read the file(s).}
}
\value{
Provided \code{package} with one additional resource.
}
\description{
Adds a Tabular \href{https://specs.frictionlessdata.io/data-resource/}{Data Resource} to a Data
Package.
The resource will be a \href{https://specs.frictionlessdata.io/tabular-data-resource/}{Tabular Data Resource}.
The resource name can only contain lowercase alphanumeric characters plus
\code{.}, \code{-} and \verb{_}.
}
\examples{
# Load the example Data Package
package <- example_package

# List resources
resources(package)

# Create a data frame
df <- data.frame(
  multimedia_id = c(
    "aed5fa71-3ed4-4284-a6ba-3550d1a4de8d",
    "da81a501-8236-4cbd-aa95-4bc4b10a05df"
  ),
  x = c(718, 748),
  y = c(860, 900)
)

# Add resource "positions" to the Data Package, from the data frame
package <- add_resource(package, "positions", data = df)

# Add resource "positions_2" to the Data Package, with user-defined schema
my_schema <- create_schema(df)
package <- add_resource(package, "positions_2", data = df, schema = my_schema)

# Add resource "observations_2" to the Data Package, from CSV file paths
path_1 <- system.file("extdata", "observations_1.csv", package = "frictionless")
path_2 <- system.file("extdata", "observations_2.csv", package = "frictionless")
package <- add_resource(package, "observations_2", data = c(path_1, path_2))

# List resources ("positions", "positions_2", "observations_2" added)
resources(package)
}
\seealso{
Other edit functions: 
\code{\link{get_schema}()},
\code{\link{remove_resource}()}
}
\concept{edit functions}
