% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rar.R
\name{rar}
\alias{rar}
\title{Simulate a multivariate autoregressive time series}
\usage{
rar(n, d = 2, Psi = NULL, burnin = 10, noise = c("mnormal", "mt"),
  sigma = NULL, df = 4)
}
\arguments{
\item{n}{number of observations to generate.}

\item{d}{dimension of the time series.}

\item{Psi}{array of \eqn{p \geq 1} coefficient matrices. \code{Psi[,,k]} is the \eqn{k}-th coefficient. If no value is set then we generate a vector autoregressive process of order 1. Then, \code{Psi[,,1]} is proportional to \eqn{\exp(-(i+j)\colon 1\leq i, j\leq d)} and such that the spectral radius of \code{Psi[,,1]} is 1/2.}

\item{burnin}{an integer \eqn{\geq 0}. It specifies a number of initial  observations to be trashed to achieve stationarity.}

\item{noise}{\code{mnormal} for multivariate normal noise or \code{mt} for multivariate student t noise. If not specified \code{mnormal} is chosen.}

\item{sigma}{covariance  or scale matrix of the innovations. By default the identity matrix.}

\item{df}{degrees of freedom if \code{noise = "mt"}.}
}
\value{
A matrix with \code{d} columns and \code{n} rows. Each row corresponds to one time point.
}
\description{
Generates a zero mean vector autoregressive process of a given order.
}
\details{
We simulate a vector autoregressive process
\deqn{
  X_t=\sum_{k=1}^p \Psi_k X_{t-k}+\varepsilon_t,\quad 1\leq t\leq n.
}
The innovation process \eqn{\varepsilon_t} is either multivariate normal or multivariate
\eqn{t} with a predefined covariance/scale matrix sigma and zero mean. The noise is generated
with the package \code{mvtnorm}. For Gaussian noise we use \code{\link[mvtnorm]{rmvnorm}}. For Student-t noise
we use \code{\link[mvtnorm]{rmvt}}. The parameters sigma and df are imported as arguments, otherwise we use default
settings. To initialise the process we set
\eqn{[X_{1-p},\ldots,X_{0}]=[\varepsilon_{1-p},\ldots,\varepsilon_{0}]}. When \code{burnin} is set
equal to \eqn{K} then, n\eqn{+K} observations are generated and the first \eqn{K} will be trashed.
}
\seealso{
\code{\link{rma}}
}
\keyword{simulations}
