% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lagged.cov.R
\name{lagged.cov}
\alias{lagged.cov}
\title{Compute cross covariance with a given lag}
\usage{
lagged.cov(X, Y = NULL, lag = 0)
}
\arguments{
\item{X}{first process}

\item{Y}{second process, if null then autocovariance of X is computed}

\item{lag}{the lag that we are interested in}
}
\value{
Covariance matrix
}
\description{
For a given multivariate stationary time series estimates a covarianve matrix
\eqn{C_{XY}^k = Cov(X_k,Y_0)} using the formula
\deqn{\hat C_{XY}^k =  \frac{1}{n} \sum_{i=1}^{n-k} X_{k+i} Y_k'. }
}
\examples{
X = rar(100)
Y = rar(100)
lagged.cov(X,Y)
}

