% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_curv.R
\name{write.fs.morph.gii}
\alias{write.fs.morph.gii}
\title{Write morphometry data in GIFTI format.}
\usage{
write.fs.morph.gii(filepath, data)
}
\arguments{
\item{filepath}{string, the full path of the output GIFTI file.}

\item{data}{numerical vector, the data to write. Will be coerced to double.}
}
\value{
format, string. The format that was used to write the data: "gii".
}
\description{
The data will be written with intent 'NIFTI_INTENT_SHAPE' and as datatype 'NIFTI_TYPE_FLOAT32'.
}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.ni1}()},
\code{\link{write.fs.morph.ni2}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph.txt}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight.asc}()},
\code{\link{write.fs.weight}()}

Other gifti writers: 
\code{\link{write.fs.annot.gii}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.surface.gii}()}
}
\concept{gifti writers}
\concept{morphometry functions}
