% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_setup.R
\name{get_fs}
\alias{get_fs}
\title{Create command declaring FREESURFER_HOME}
\usage{
get_fs(bin_app = c("bin", "mni/bin", ""))
}
\arguments{
\item{bin_app}{Should \code{bin} be added to the freesurfer path? 
All executables are assumed to be in \code{FREESURFER_HOME/bin/}.  If not, and 
\code{bin_app = ""}, they will be assumed to be in \code{FREESURFER_HOME/}.}
}
\value{
NULL if Freesurfer in path, or bash code for setting up Freesurfer DIR
}
\description{
Finds the Freesurfer from system environment or \code{getOption("freesurfer.path")}
for location of Freesurfer functions
}
\note{
This will use \code{Sys.getenv("FREESURFER_HOME")} before \code{getOption("freesurfer.path")}.
If the directory is not found for Freesurfer in \code{Sys.getenv("FreesurferDIR")} and 
\code{getOption("freesurfer.path")}, it will try the default directory \code{/usr/local/freesurfer}.
}
\examples{
if (have_fs()) {
get_fs()
}
}

