% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_categories.R
\name{fredr_series_categories}
\alias{fredr_series_categories}
\title{Get the categories for a FRED series}
\usage{
fredr_series_categories(series_id = NULL, realtime_start = NULL,
  realtime_end = NULL)
}
\arguments{
\item{series_id}{A string ID for the FRED series. \emph{Required parameter.}}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object with information on the categories to
which the series specified by \code{series_id} belongs.  Data include category ID,
name, parent category ID, and notes.
}
\description{
Given a series ID, return information on the categories to which a series belongs
as a \code{tibble} object.
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/series_categories.html}{fred/series/categories}
}

\examples{
\donttest{
# Return the categories to which the "UNRATE" series belongs
fredr_series_categories(series_id = "UNRATE")
}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series]{fredr_series()}},
\code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_updates]{fredr_series_updates()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
