% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHelp.R
\docType{data}
\name{gastadj}
\alias{gastadj}
\title{Advanced Gastric Cancer dataset}
\format{This data frame contains the following columns: 
\describe{
\item{trialID}{The trial in which the patient was treated}
\item{patienID}{The identification number of a patient} 
\item{trt}{The treatment indicator, coded as 0 = Control and 1 = Experimental}
\item{timeS}{The candidate surrogate (progression-free survival in days) }
\item{statusS}{Censoring indicator for for Progression-free survival 
(0 = alive and progression-free, 1 = with progression or dead)}
\item{timeT}{The true endpoint (overall survival time in days)}
\item{statusT}{Censoring indicator for survival time (0 = alive, 1 = dead)}
}}
\source{
Oba K, Paoletti X, Alberts S, Bang YJ, Benedetti J, Bleiberg H, Catalona P, 
Lordick F, Michiels S, Morita A, Okashi Y, Pignon JP, Rougier P, Sasako M, 
Sakamoto J, Sargent D, Shitara K, Van Cutsem E, Buyse M, Burzykowski T on 
behalf of the GASTRIC group (2013). Disease-Free Survival as a Surrogate 
for Overall Survival in Adjuvant Trials of Gastric Cancer: A Meta-Analysis. 
\emph{JNCI: Journal of the National Cancer Institute};\bold{105(21)}:1600-1607
}
\usage{
data(gastadj)
}
\description{
This meta-analysis was carried out by the GASTRIC (Global Advanced/Adjuvant Stomach 
Tumor Research international Collaboration) group, using individual data on patients 
with curatively resected gastric cancer. Data from all published randomized trials, 
with a patient recruitment end date before 2004, and comparing adjuvant chemotherapy 
with surgery alone for resectable gastric cancers, were searched electronically. 
The candidate surrogate endpoint \bold{S} was Desease-free survival time, defined 
as the time (in days) to relapse, second cancer or dead from any cause. The true 
endpoint \bold{T} was the overall survival time, defined as the time (in days) from 
randomization to death of any cause or to the last follow-up.
}
\keyword{datasets}
