% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_point_cloud.R
\name{generate_point_cloud}
\alias{generate_point_cloud}
\title{Generate a Point Cloud from 2D trees data frame}
\usage{
generate_point_cloud(tree_df, pt_distance = 0.3)
}
\arguments{
\item{tree_df}{A data.frame resulting from the \code{build_tree} or \code{build_forest_profile} functions. It contains the tree geometry data.}

\item{pt_distance}{A numeric value specifying the distance between points in the generated point cloud. The default is 0.3. Smaller values will result in a denser point cloud. Small values may significantly increase the execution time of the function due to the larger number of points being generated.}
}
\value{
A matrix of 2D coordinates representing the point cloud. Each row corresponds to a point in the cloud, with the columns representing the X and Y coordinates.
}
\description{
This function generates a point cloud based on the geometry of a tree or forest profile.
}
\details{
This function processes the input \code{tree_df} by creating lines from the tree's geometry and then buffers these lines to account for the tree's diameter. A grid is then created over the buffered geometry, and points are generated where the grid intersects the geometry. The result is a point cloud of 2D coordinates representing the tree's profile.
}
