% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftply.R
\name{ftply}
\alias{ftply}
\title{Read, process each block and return a data.table}
\usage{
ftply(
  input,
  FUN = function(d, by) d,
  ...,
  key.sep = "\\t",
  sep = "\\t",
  skip = 0,
  header = TRUE,
  nblocks = Inf,
  stringsAsFactors = FALSE,
  colClasses = NULL,
  select = NULL,
  drop = NULL,
  col.names = NULL,
  parallel = 1
)
}
\arguments{
\item{input}{Path of the input file.}

\item{FUN}{Function to be applied to each block. It must take at least two arguments,
the first of which is a \code{data.table} containing the current block, \emph{without
the first field}; the second argument is a character vector containing the
value of the first field for the current block.}

\item{...}{Additional arguments to be passed to FUN.}

\item{key.sep}{The character that delimits the first field from the rest.}

\item{sep}{The field delimiter (often equal to \code{key.sep}).}

\item{skip}{Number of lines to skip at the beginning of the file}

\item{header}{Whether the file has a header.}

\item{nblocks}{The number of blocks to read.}

\item{stringsAsFactors}{Whether to convert strings into factors.}

\item{colClasses}{Vector or list specifying the class of each field.}

\item{select}{The columns (names or numbers) to be read.}

\item{drop}{The columns (names or numbers) not to be read.}

\item{col.names}{Names of the columns.}

\item{parallel}{Number of cores to use.}
}
\value{
Returns a \code{data.table} with the results of the
processing.
}
\description{
\code{ftply} takes as input the path to a file and a function, and
returns a \code{data.table}. It is a faster equivalent to using
\code{l <- flply(...)} followed by \code{do.call(rbind, l)}.
}
\details{
\code{ftply} is similar to \code{ffply}, but while the latter writes
to disk the result of the processing after each block, the former
keeps the result in memory until all the file has been processed, and
then returns the complete \code{data.table}.
}
\section{Slogan}{

ftply: from \strong{f}ile to data.\strong{t}able
}

\examples{
f1 <- system.file("extdata", "dt_iris.csv", package = "fplyr")

# Compute the mean of the columns for each species
ftply(f1, function(d, by) d[, lapply(.SD, mean)])

# Read only the first two blocks
ftply(f1, nblocks = 2)

}
