% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DW_Server.R
\name{DW_append_report}
\alias{DW_append_report}
\title{Append Report Elements}
\usage{
DW_append_report(state, rpt, rpttype, gen_code_only = FALSE)
}
\arguments{
\item{state}{DW state from \code{DW_fetch_state()}}

\item{rpt}{Report with the current content of the report which will be appended to in
this function. For details on the structure see the documentation for \code{\link{FM_generate_report}}.}

\item{rpttype}{Type of report to generate (supported "xlsx").}

\item{gen_code_only}{Boolean value indicating that only code should be
generated (\code{FALSE}).}
}
\value{
list containing the following elements
\itemize{
 \item{isgood:}    Return status of the function.
 \item{hasrptele:} Boolean indicator if the module has any reportable elements.
 \item{code:}      Code to generate reporting elements.
 \item{msgs:}      Messages to be passed back to the user.
 \item{rpt:}       Report with any additions passed back to the user.
}
}
\description{
Takes the current state of the app and appends data views to an
xlsx report object.
}
\examples{
# We need a state object to use below
sess_res = DW_test_mksession()
state = sess_res$state

rpt = list(summary = list(), sheets=list())

rpt_res = DW_append_report(state,
  rpt     = rpt,
  rpttype = "xlsx")

# Shows if report elements are present
rpt_res$hasrptele

# Code chunk to generate report element
cat(paste(rpt_res$code, collapse="\n"))

# Tabular summary of data views
rpt_res$rpt$summary
}
\seealso{
\code{\link{FM_generate_report}}
}
