% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{var_labels<-}
\alias{var_labels<-}
\title{Set Label Attributes of All Variables in a \code{data.frame}}
\usage{
var_labels(x) <- value
}
\arguments{
\item{x}{a \code{data.frame} object}

\item{value}{new variable labels, \code{NA} removes the variable label}
}
\value{
modifies the variable labels of \code{x}
}
\description{
Variable labels can be stored as a \code{label} attribute for each variable.
This functions sets all non-missing (non-NA) variable labels in a \code{data.frame}
}
\examples{
x <- iris
var_labels(x)
var_labels(x) <- paste("label for", names(iris))
var_labels(x)

if(interactive()){
View(x) # in RStudio data viewer labels are displayed
}
}
