% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLAD.R
\name{fd_forest_extent_glad}
\alias{fd_forest_extent_glad}
\title{Download Forest Extent}
\usage{
fd_forest_extent_glad(
  x = NULL,
  lon = NULL,
  lat = NULL,
  year = 2020,
  crop = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{sf} or \code{SpatVector} object. It will retrieve the
necessary tiles to cover the area (if \code{lat} and \code{lon} are
specified, this argument is ignored)}

\item{lon}{A number specifying the longitude of the area where we want the tile}

\item{lat}{A number specifying the latitude of the area where we want the tile}

\item{year}{Year of the forest extent data. One of 2000, 2020 or 'all'}

\item{crop}{When \code{x} is specified, whether to crop the tiles(s) to the
object}

\item{...}{additional arguments passed to the `terra::crop()` function}
}
\value{
\code{SpatRaster} object
}
\description{
Download the Forest Extent raster from the Global Land Analysis & Discovery by
using a vectorial object or a pair of coordinates (latitude, longitude).
}
\details{
The Forest Extent Map is a product offered by the Global Land Analysis &
Discovery organization. The spatial resolution of the product is 0.00025º
(approximately 30 meters at the Equator), and it's distributed in tiles of
10ºx10º. Pixels with forest height > 5 meters are classified as the forest class.

Note that each tile is stored as a raster file of 1.5 GB, so for
big extensions the function might take some time to retrieve the data.
}
\examples{
\donttest{
 # Get tile for Galicia (Spain)
 galicia_forest_extent <- fd_forest_extent_glad(lon = -7.8, lat = 42.7, year = 2020)
}
}
\references{
P. Potapov, X. Li, A. Hernandez-Serna, A. Tyukavina, M.C. Hansen,
            A. Kommareddy, A. Pickens, S. Turubanova, H. Tang, C.E. Silva,
            J. Armston, R. Dubayah, J. B. Blair, M. Hofton (2020) Mapping
            and monitoring global forest canopy height through integration
            of GEDI and Landsat data. Remote Sensing of Environment,
            112165. https://doi.org/10.1016/j.rse.2020.112165
}
