% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup_folders.R
\name{cleanup_folders}
\alias{cleanup_folders}
\title{Cleanup Folders}
\usage{
cleanup_folders(folders, conf_file, keep_conf = TRUE)
}
\arguments{
\item{folders}{(list) A named list of standard folders for an R project.
(Default: folders::get_folders())}

\item{conf_file}{(character) Configuration file to read/write. 
See: config::get().}

\item{keep_conf}{(boolean) Keep the configuration file if TRUE. (Default: TRUE)}
}
\value{
(integer) A vector of results: 0 for success; 1 for failure; NULL for skipped.
}
\description{
Remove empty folders from the folders list as well as the configuration file.
}
\section{Details}{

Each non-empty folder in the list of folders will be removed. The configuration  
file will also be removed if keep_conf is set to FALSE.
}

\examples{
conf <- tempfile("folders.yml")
folders <- get_folders(conf)
folders <- lapply(folders, function(x) file.path(tempdir(), x))
result <- create_folders(folders)
result <- cleanup_folders(folders, conf)
}
\keyword{consistency}
