% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getDownSampleInd}
\alias{getDownSampleInd}
\title{Helper Function to Generate Training Set Indices Through Downsampling}
\usage{
getDownSampleInd(response, downSampling = FALSE, kSample = NULL)
}
\arguments{
\item{response}{A factor vector representing the class labels.}

\item{downSampling}{A logical value indicating whether downsampling should be
applied. If \code{TRUE}, downsampling is performed to limit the number of
samples per class based on \code{kSample}. Note that this may not result in
equal class frequencies, as \code{kSample} defines an upper limit for each
class, not a lower limit.}

\item{kSample}{An integer specifying the maximum number of samples to be
selected per class. If \code{NULL}, the number of samples is limited to the size
of the smallest class.}
}
\value{
An integer vector of indices representing the selected samples from
the original \code{response} vector.
}
\description{
This function selects the indices for the training set based on the class
vector \code{response}. It allows for optional downsampling to balance the class
distribution by limiting the number of samples per class.
}
