% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_1d.R
\name{fm_mesh_1d}
\alias{fm_mesh_1d}
\title{Make a 1D mesh object}
\usage{
fm_mesh_1d(
  loc,
  interval = range(loc),
  boundary = NULL,
  degree = 1,
  free.clamped = FALSE,
  ...
)
}
\arguments{
\item{loc}{B-spline knot locations.}

\item{interval}{Interval domain endpoints.}

\item{boundary}{Boundary condition specification.  Valid conditions are
\code{c('neumann', 'dirichlet', 'free', 'cyclic')}.  Two separate values can
be specified, one applied to each endpoint.}

\item{degree}{The B-spline basis degree.  Supported values are 0, 1, and 2.}

\item{free.clamped}{If \code{TRUE}, for \code{'free'} boundaries, clamp the
basis functions to the interval endpoints.}

\item{\dots}{Additional options, currently unused.}
}
\value{
An \code{fm_mesh_1d} object
}
\description{
Create a \code{fm_mesh_1d} object.
}
\examples{
if (require("ggplot2")) {
  m <- fm_mesh_1d(c(1, 2, 3, 5, 8, 10),
    boundary = c("neumann", "free"),
    degree = 2
  )
  ggplot() +
    geom_fm(data = m, xlim = c(0.5, 10.5))
}

}
\seealso{
Other object creation and conversion: 
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\concept{object creation and conversion}
