% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorMLR3.R
\name{PredictorMLR3}
\alias{PredictorMLR3}
\title{PredictorMLR3}
\description{
This task specializes \link{Predictor} for \code{mlr3} models.
The \code{model} is assumed to be a \code{LearnerRegr} or \code{LearnerClassif}.

It is recommended to use \code{\link[=makePredictor]{makePredictor()}} for construction of Predictor objects.
}
\section{Super class}{
\code{\link[fmeffects:Predictor]{fmeffects::Predictor}} -> \code{PredictorMLR3}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictorMLR3-new}{\code{PredictorMLR3$new()}}
\item \href{#method-PredictorMLR3-predict}{\code{PredictorMLR3$predict()}}
\item \href{#method-PredictorMLR3-clone}{\code{PredictorMLR3$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorMLR3-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorMLR3-new}{}}}
\subsection{Method \code{new()}}{
Create a new PredictorMLR3 object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorMLR3$new(model, data, target)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{\code{LearnerRegr} or \code{LearnerClassif} object.}

\item{\code{data}}{The data used for computing FMEs, must be data.frame or data.table.}

\item{\code{target}}{A string specifying the target variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorMLR3-predict"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorMLR3-predict}{}}}
\subsection{Method \code{predict()}}{
Predicts on an observation \code{"newdata"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorMLR3$predict(newdata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{The feature vector for which the target should be predicted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorMLR3-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorMLR3-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorMLR3$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
