context("Counters")

suppressPackageStartupMessages(library(lubridate))

test_that("year_frac works as expected", {
  expect_equal(year_frac(ymd("20100331"), ymd("20120331"), "30/360us"), 2.00000000000000000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100228"), ymd("20120331"), "30e/360"), 2.08888888888889000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100228"), ymd("20120331"), "act/360"), 2.11666666666667000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100228"), ymd("20120331"), "act/365"), 2.08767123287671000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100228"), ymd("20120331"), "act/actisda"), 2.08699752975531000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100228"), ymd("20120331"), "30e/360isda"), 2.08333333333333000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100228"), ymd("20120331"), "30e+/360"), 2.09166666666667000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20110430"), ymd("20211231"), "30/360us"), 10.66666666666670000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20110430"), ymd("20211231"), "30e/360"), 10.66666666666670000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20110430"), ymd("20211231"), "act/360"), 10.82777777777780000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20110430"), ymd("20211231"), "act/365"), 10.67945205479450000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20110430"), ymd("20211231"), "act/actisda"), 10.67123287671230000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20110430"), ymd("20211231"), "30e/360isda"), 10.66666666666670000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20110430"), ymd("20211231"), "30e+/360"), 10.66944444444440000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20321231"), "30/360us"), 20.75000000000000000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20321231"), "30e/360"), 20.75000000000000000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20321231"), "act/360"), 21.05555555555560000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20321231"), "act/365"), 20.76712328767120000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20321231"), "act/actisda"), 20.75136612021860000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20321231"), "30e/360isda"), 20.75000000000000000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20321231"), "30e+/360"), 20.75277777777780000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20120625"), "act/365"), 0.23561643835616400000, tolerance=1e20)
  expect_equal(year_frac(ymd("20120331"), ymd("20120625"), "act/actisda"), 0.23497267759557900000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100330"), ymd("20120228"), "30e/360isda"), 1.91111111111111000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100330"), ymd("20120331"), "30e/360isda"), 2.00000000000000000000, tolerance=1e20)
  expect_equal(year_frac(ymd("20100330"), ymd("20120331"), "30e/360isda"), 2.00000000000000000000, tolerance=1e20)
  expect_equal(year_frac(ymd_hms(20140827100000, tz='Australia/Sydney'), ymd_hms(20141008100000, tz='Australia/Sydney'), 'act/365') * 365, 42)
  expect_equal(year_frac(ymd("20100331"), ymd("20110315"), "30/360"), 1 - 15 / 360)
  expect_equal(year_frac(ymd("20100331"), ymd("20110331"), "30/360"), 1.0)
  expect_equal(year_frac(ymd("20100330"), ymd("20110331"), "30/360"), 1.0)
  expect_equal(year_frac(ymd("20100315"), ymd("20110315"), "30/360"), 1.0)
  expect_equal(year_frac(ymd("20110315"), ymd("20100315"), "30/360"), -1.0)
})

test_that('year_frac deals with NAs appropriately', {
  expect_equal(year_frac(NA, ymd("20120331"), "act/365"), NA_real_)
})
