% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to-flow.R
\name{to_flow}
\alias{to_flow}
\alias{flowr}
\alias{is.flow}
\alias{to_flow.character}
\alias{to_flow.flowmat}
\alias{to_flow.data.frame}
\alias{to_flow.list}
\title{Create flow objects}
\usage{
to_flow(x, ...)

is.flow(x)

\method{to_flow}{character}(x, def, grp_col, jobname_col, cmd_col, ...)

\method{to_flow}{flowmat}(
  x,
  def,
  flowname,
  grp_col,
  jobname_col,
  cmd_col,
  submit = FALSE,
  execute = FALSE,
  containerize = TRUE,
  platform,
  flow_run_path,
  qobj,
  verbose = opts_flow$get("verbose"),
  ...
)

\method{to_flow}{data.frame}(x, ...)

\method{to_flow}{list}(
  x,
  def,
  flowname,
  flow_run_path,
  desc,
  qobj,
  module_cmds = opts_flow$get("module_cmds"),
  verbose = opts_flow$get("verbose"),
  ...
)
}
\arguments{
\item{x}{this can either to a filename, a data.frame or a list. 
In case it is a file name, it should be a tsv file representing a flow_mat. See \link{to_flowmat} for details}

\item{...}{Supplied to specific functions like \link{to_flow.data.frame}}

\item{def}{a flow definition. Basically a table with resource requirements and mapping of the jobs in this flow.
See \link{to_flowdef} for details on the format.}

\item{grp_col}{name of the grouping column in the supplied flow_mat.
See \link{to_flow} for details. Default value is [samplename].}

\item{jobname_col}{name of the job name column in flow_mat. Default value is [jobname].}

\item{cmd_col}{name of the command column name in flow_mat. Default value is [cmd].}

\item{flowname}{name of the flow, this is used as part of the execution foldername.
A good simple identifier, which does not support any special characters. 
Names may use characters (a-z) and numbers (0-9), using underscore (_) as a word separator.
Default value is  [flowname].}

\item{submit}{after creating a flow object, should flowr 
also use \link{submit_flow} to perform a dry-run OR real submission.
See below for details. Default value is [FALSE]}

\item{execute}{when calling \link{submit_flow}, 
should flowr execute the flow or perform a dry-run. See below for details. Default value is [FALSE].}

\item{containerize}{if the flowmat has multiple samples, 
flowr creates a creates a new date-stamped folder, and includes all
flows in this batch inside it. 
This is keeps the logs clean, and containerizes each batch.
To disable this behavior set this to FALSE, default is [TRUE].}

\item{platform}{a specifying the platform to use, possible values are local, lsf, torque, moab, sge and slurm
This over-rides the platform column in the flowdef. (optional)}

\item{flow_run_path}{base path to be used for execution of this flow. 
flowr would create a new time-stamped folder in this base path and 
use it for logs, scripts etc. 
The default is retrieved using \code{opts_flow$get("flow_run_path")}.}

\item{qobj}{Depreciated, modify cluster templates as explained on 
\href{http://flow-r.github.io/flowr/install.html#hpcc_support_overview}{flow-r.github.io/flowr}.
An object of class \link{queue}.}

\item{verbose}{A numeric value indicating the amount of messages to produce.
 Values are integers varying from 0, 1, 2, 3, .... Please refer to the \link{verbose} page for more details.
\code{opts_flow$get("verbose")}}

\item{desc}{Advanced Use. final flow name.}

\item{module_cmds}{A character vector of additional commands, which will be prepended to each script of the flow. 
Default is retrieved using \code{opts_flow$get("module_cmds")}.}
}
\value{
Returns a flow object. If execute=TRUE, fobj is rich with information about where and how
the flow was executed. It would include details like jobids, path to exact scripts run etc.
To use kill_flow, to kill all the jobs one would need a rich flow object, with job ids present.

\strong{Behaviour:}{
What goes in, and what to expect in return?
\itemize{
\item submit=FALSE & execute=FALSE: Create and return a flow object
\item submit=TRUE & execute=FALSE: dry-run, Create a flow object then, create a structured execution folder with all the commands
\item submit=TRUE, execute=TRUE: Do all of the above and then, submit to cluster
}
}
}
\description{
Use a set of shell commands (flow mat) and flow definition to create \link{flow} object.
}
\details{
The parameter x can be a path to a flow_mat, or a data.frame (as read by read_sheet).
This is a minimum three column table with columns: samplename, jobname and cmd.
See \link{to_flowmat} for details.
}
\examples{
## Use this link for a few elaborate examples:
## http://flow-r.github.io/flowr/flowr/tutorial.html#define_modules

ex = file.path(system.file(package = "flowr"), "pipelines")
flowmat = as.flowmat(file.path(ex, "sleep_pipe.tsv"))
flowdef = as.flowdef(file.path(ex, "sleep_pipe.def"))
fobj = to_flow(x = flowmat, def = flowdef, flowname = "sleep_pipe", platform = "lsf")


## create a vector of shell commands
cmds = c("sleep 1", "sleep 2")
## create a named list
lst = list("sleep" = cmds)
## create a flowmat
flowmat = to_flowmat(lst, samplename = "samp")

## Use flowmat to create a skeleton flowdef
flowdef = to_flowdef(flowmat)

## use both (flowmat and flowdef) to create a flow
fobj = to_flow(flowmat, flowdef)

## submit the flow to the cluster (execute=TRUE) or do a dry-run (execute=FALSE)
\dontrun{
fobj2 = submit_flow(fobj, execute=FALSE)
fobj3 = submit_flow(fobj, execute=TRUE)

## Get the status or kill all the jobs
status(fobj3)
kill(fobj3)
}


}
\seealso{
\link{to_flowmat}, \link{to_flowdef}, \link{to_flowdet}, \link{flowopts} and \link{submit_flow}
}
