% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_filter.R
\name{fc_filter}
\alias{fc_filter}
\title{fc_filter}
\usage{
fc_filter(
  object,
  filter = NULL,
  N = NULL,
  label = NULL,
  text_pattern = "{label}\\n {n} ({perc}\%)",
  show_exc = FALSE,
  direction_exc = "right",
  label_exc = "Excluded",
  text_pattern_exc = "{label}\\n {n} ({perc}\%)",
  sel_group = NULL,
  round_digits = 2,
  just = "center",
  text_color = "black",
  text_fs = 8,
  bg_fill = "white",
  border_color = "black",
  just_exc = "center",
  text_color_exc = "black",
  text_fs_exc = 6,
  bg_fill_exc = "white",
  border_color_exc = "black"
)
}
\arguments{
\item{object}{fc object that we want to filter.}

\item{filter}{Expression that returns a logical value and are defined in terms of the variables in the data frame. The data base will be filtered by this expression, and it will create a box showing the number of rows satisfying this condition.}

\item{N}{Number of rows after the filter in case `filter` is NULL.}

\item{label}{Character that will be the title of the box. By default it will be the evaluated condition.}

\item{text_pattern}{Structure that will have the text in each of the boxes. It recognizes label, n, N and perc within brackets. For default it is "\{label\}\\n \{n\} (\{perc\}\%)".}

\item{show_exc}{Logical value. If TRUE a box showing the number of excluded rows will be added to the flow chart.}

\item{direction_exc}{One of "left" or "right" indicating if the exclusion box goes into the left direction or in the right direction. By default is "right".}

\item{label_exc}{Character that will be the title of the added box showing the excluded patients. By default it will show "Excluded".}

\item{text_pattern_exc}{Structure that will have the text in each of the excluded boxes. It recognizes label, n, N and perc within brackets. For default it is "\{label\}\\n \{n\} (\{perc\}\%)".}

\item{sel_group}{Specify if the filtering has to be done only by one of the previous groups. By default is NULL.}

\item{round_digits}{Number of digits to round percentages. It is 2 by default.}

\item{just}{Justification for the text: left, center or right. Default is center.}

\item{text_color}{Color of the text. It is black by default.}

\item{text_fs}{Font size of the text. It is 8 by default.}

\item{bg_fill}{Box background color. It is white by default.}

\item{border_color}{Box border color. It is black by default.}

\item{just_exc}{Justification for the text of the exclude box: left, center or right. Default is center.}

\item{text_color_exc}{Color of the text of the exclude box. It is black by default.}

\item{text_fs_exc}{Font size of the text of the exclude box. It is 6 by default.}

\item{bg_fill_exc}{Exclude box background color. It is white by default.}

\item{border_color_exc}{Box background color of the exclude box. It is black by default.}
}
\value{
List with the filtered dataset and the flowchart parameters with the resulting filtered box.
}
\description{
This function allows to filter the flowchart in function of a expression that returns a logic value that are defined in terms of the variables in the database. It will generate one box per group showing the number of rows of the group that matches the condition, and will retain only those rows in the data base.
}
\examples{
clinic_patient |>
  as_fc(label = "Patients included") |>
  fc_filter(age >= 18 & consent == "Yes", label = "Patients included", show_exc = TRUE) |>
  fc_draw()

}
