% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one-sample-test.R
\name{one_sample_test}
\alias{one_sample_test}
\title{One-Sample Permutation Test}
\usage{
one_sample_test(
  x,
  stats = list(stat_max),
  B = 1000L,
  M = NULL,
  alternative = "two_tail",
  combine_with = "tippett",
  type = "exact",
  seed = NULL
)
}
\arguments{
\item{x}{A numeric vector or a numeric matrix or a list representing the
sample from which the user wants to make inference.}

\item{stats}{A list of functions produced by \code{\link[rlang]{as_function}}
specifying the chosen test statistic(s). A number of test statistic
functions are implemented in the package and can be used as such.
Alternatively, one can provide its own implementation of test statistics
that (s)he deems relevant for the problem at hand. See the section
\emph{User-supplied statistic function} for more information on how these
user-supplied functions should be structured for compatibility with the
\strong{flipr} framework. Default is \code{list(\link{stat_t})}.}

\item{B}{The number of sampled permutations. Default is \code{1000L}.}

\item{M}{The total number of possible permutations. Defaults to \code{NULL}, which
means that it is automatically computed from the given sample size(s).}

\item{alternative}{A single string or a character vector specifying whether
the p-value is right-tailed, left-tailed or two-tailed. Choices are
\code{"right_tail"}, \code{"left_tail"} and \code{"two_tail"}. Default is \code{"two_tail"}. If
a single string is provided, it is assumed that it should be applied to all
test statistics provided by the user. Alternative, the length of
\code{alternative} should match the length of the \code{stats} parameter and it is
assumed that there is a one-to-one correspondence.}

\item{combine_with}{A string specifying the combining function to be used to
compute the single test statistic value from the set of p-value estimates
obtained during the non-parametric combination testing procedure. For now,
choices are either \code{"tippett"} or \code{"fisher"}. Default is \code{"tippett"}, which
picks Tippett's function.}

\item{type}{A string specifying which formula should be used to compute the
p-value. Choices are \code{exact} (default), \code{upper_bound} and \code{estimate}. See
Phipson & Smith (2010) for details.}

\item{seed}{An integer specifying the seed of the random generator useful for
result reproducibility or method comparisons. Default is \code{NULL}.}
}
\value{
A \code{\link[base]{list}} with three components: the value of the
statistic for the original two samples, the p-value of the resulting
permutation test and a numeric vector storing the values of the permuted
statistics.
}
\description{
This function carries out an hypothesis test where the null hypothesis is
that the sample is governed by a generative probability distribution which is
centered and symmetric against the alternative hypothesis that they are
governed by a probability distribution that is either not centered or not
symmetric.
}
\section{User-supplied statistic function}{

A user-specified function should have at least two arguments:
\itemize{
\item the first argument is \code{data} which should be a list of the \code{n}
observations from the sample;
\item the second argument is \code{flips} which should be an integer vector giving
the signs by which each observation in \code{data} should be multiplied.
}

It is possible to use the \code{\link{use_stat}} function with \code{nsamples = 1}
to have \strong{flipr} automatically generate a template file for writing down
your own test statistics in a way that makes it compatible with the \strong{flipr}
framework.

See the \code{\link{stat_max}} function for an example.
}

\examples{
n <- 10L
mu <- 3
sigma <- 1

# Sample under the null distribution
x1 <- rnorm(n = n, mean = 0, sd = sigma)
t1 <- one_sample_test(x1)
t1$pvalue

# Sample under some alternative distribution
x2 <- rnorm(n = n, mean = mu, sd = sigma)
t2 <- one_sample_test(x2)
t2$pvalue
}
