% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{grid_biregular}
\alias{grid_biregular}
\title{Create a biregular grid around a center point}
\usage{
grid_biregular(
  x,
  ...,
  center = NULL,
  levels = 3,
  original = TRUE,
  filter = NULL
)
}
\arguments{
\item{x}{A \code{param} object, list, or \code{parameters}.}

\item{...}{One or more \code{param} objects (such as \code{\link[dials:mtry]{mtry()}} or
\code{\link[dials:penalty]{penalty()}}). None of the objects can have \code{unknown()} values in
the parameter ranges or values.}

\item{center}{A numeric vector specifying the point onto which the biregular
grid should be centered. Defaults to \code{NULL}, in which case
\code{\link[dials]{grid_regular}} is used instead.}

\item{levels}{An integer for the number of values of each parameter to use
to make the regular grid. \code{levels} can be a single integer or a vector of
integers that is the same length as the number of parameters in \code{...}.
\code{levels} can be a named integer vector, with names that match the id values
of parameters.}

\item{original}{A logical: should the parameters be in the original units or
in the transformed space (if any)?}

\item{filter}{A logical: should the parameters be filtered prior to
generating the grid. Must be a single expression referencing parameter
names that evaluates to a logical vector.}
}
\value{
A tibble. There are columns for each parameter and a row for every
parameter combination.
}
\description{
Biregular grids can be created for any number of parameter objects.
}
\details{
Note that there may a difference in grids depending on how the function
is called. If the call uses the parameter objects directly the possible
ranges come from the objects in \code{dials}. For example:\if{html}{\out{<div class="r">}}\preformatted{mixture()
}\if{html}{\out{</div>}}\preformatted{## Proportion of lasso Penalty  (quantitative)
## Range: [0, 1]
}\if{html}{\out{<div class="r">}}\preformatted{set.seed(283)
mix_grid_1 <- grid_random(mixture(), size = 1000)
range(mix_grid_1$mixture)
}\if{html}{\out{</div>}}\preformatted{## [1] 0.001490161 0.999741096
}

However, in some cases, the \code{tune} package overrides the default ranges
for specific models. If the grid function uses a \code{parameters} object
created from a model or recipe, the ranges my have different defaults
(specific to those models). Using the example above, the \code{mixture}
argument above is different for \code{glmnet} models:\if{html}{\out{<div class="r">}}\preformatted{library(parsnip)
library(tune)

# When used with glmnet, the range is [0.05, 1.00]
glmn_mod <-
  linear_reg(mixture = tune()) \%>\%
  set_engine("glmnet")

set.seed(283)
mix_grid_2 <- grid_random(parameters(glmn_mod), size = 1000)
range(mix_grid_2$mixture)
}\if{html}{\out{</div>}}\preformatted{## [1] 0.05141565 0.99975404
}
}
\examples{
grid_biregular(dials::mixture(), center = 0.2)
}
