% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-viz.R
\name{two_sample_viz}
\alias{two_sample_viz}
\title{Two-Sample Permutation P-Value Function Graph}
\usage{
two_sample_viz(
  null_specification,
  x,
  y,
  alpha = 0.05,
  statistic = stat_hotelling,
  B = 1000L,
  alternative = "two_tail",
  type = "exact",
  point_estimate = NULL,
  confidence_interval = NULL,
  lower_bound = 0,
  upper_bound = 1,
  n_grid_in = 20L,
  n_grid_out = 100L,
  seed = NULL
)
}
\arguments{
\item{null_specification}{A function with two arguments \code{y} and \code{parameters}
such that \verb{F_X = F_\{null_specification(Y, parameters)\}} under the null
hypothesis.}

\item{x}{A list or matrix representing the 1st sample.}

\item{y}{A list or matrix representing the 2nd sample.}

\item{alpha}{A scalar specifying the desired significance level. Default is
\code{0.05}.}

\item{statistic}{A character vector specifying the chosen test statistic(s).
These can be \code{\link{stat_hotelling}} or user-specified functions that
define desired statistics. See the section \emph{User-supplied statistic
function} for more information on how these user-supplied functions should
be structured for compatibility with the \strong{flipr} framwork. Default is
\code{\link{stat_hotelling}}.}

\item{B}{The number of sampled permutation. Default is \code{1000L}.}

\item{alternative}{A string specifying whether the p-value is right-tailed,
left-tailed or two-tailed. Choices are \code{"right_tail"}, \code{"left_tail"} and
\code{"two_tail"}. Default is \code{"right_tail"}. Obviously, if the test statistic
used in argument \code{statistic} is positive, all alternatives will lead to the
two-tailed p-value.}

\item{type}{A string specifying if performing an exact test through the use
of Phipson-Smyth estimate of the p-value or an approximate test through a
Monte-Carlo estimate of the p-value. Default is \code{"exact"}.}

\item{point_estimate}{A scalar providing a point estimate of the parameter
under investigation. Default is \code{NULL}, in which case the point estimate is
computed by maximizing the p-value function via the
\code{\link{two_sample_pe}} function.}

\item{confidence_interval}{A length-2 numerical vector providing a confidence
interval for the parameter under investigation to be used for setting the
boundaries of the grid onto which the p-value will be displayed. Default is
\code{NULL}, in which case the confidence interval is computed via the
\code{\link{two_sample_ci}} function.}

\item{lower_bound}{A scalar value specifying a rough lower bound of the
interval over which searching the maximum of the p-value function. Default
is \code{0}.}

\item{upper_bound}{A scalar value specifying a rough upper bound of the
interval over which searching the maximum of the p-value function. Default
is \code{1}.}

\item{n_grid_in}{An integer specifying the size of the grid onto which the
p-value function will actually be evaluated. Default is \code{20L}.}

\item{n_grid_out}{An integer specifying the size of the grid onto which the
p-value function will be extrapolated for display. Default is \code{100L}.}

\item{seed}{An integer specifying the seed of the random generator useful for
result reproducibility or method comparisons. Default is \code{NULL}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
This function plots the p-value function for a single parameter of interest,
estimated via permutations.
}
\examples{
x1 <- rnorm(10)
x2 <- rnorm(10, mean = 3)
null_spec <- function(y, parameters) {y - parameters[1]}
\dontrun{
 two_sample_viz(
    null_specification = null_spec,
    x = x1,
    y = x2,
    statistic = stat_t,
    B = 10000
  )
}
}
