% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_vader}
\alias{theme_vader}
\title{Apply Sith Lord Darth Vader theme}
\usage{
theme_vader(x, ...)
}
\arguments{
\item{x}{a flextable object}

\item{...}{unused}
}
\description{
Apply Sith Lord Darth Vader theme to a flextable
}
\section{Illustrations}{


\if{html}{\figure{fig_theme_vader_1.png}{options: width="400"}}
}

\section{behavior}{

Theme functions are not like 'ggplot2' themes. They are applied to the existing
table \strong{immediately}. If you add a row in the footer, the new row is not formatted
with the theme. The theme function applies the theme only to existing elements
when the function is called.

That is why theme functions should be applied after all elements of the table
have been added (mainly additionnal header or footer rows).

If you want to automatically apply a theme function to each flextable,
you can use the \code{theme_fun} argument of \code{\link[=set_flextable_defaults]{set_flextable_defaults()}}; be
aware that this theme function is applied as the last instruction when
calling \code{flextable()} - so if you add headers or footers to the array,
they will not be formatted with the theme.

You can also use the \code{post_process_html} argument
of \code{\link[=set_flextable_defaults]{set_flextable_defaults()}} (or \code{post_process_pdf},
\code{post_process_docx}, \code{post_process_pptx}) to specify a theme
to be applied systematically before the \code{flextable()} is printed;
in this case, don't forget to take care that the theme doesn't
override any formatting done before the print statement.
}

\examples{
ft <- flextable(head(airquality))
ft <- theme_vader(ft)
ft
}
\seealso{
Other functions related to themes: 
\code{\link{get_flextable_defaults}()},
\code{\link{set_flextable_defaults}()},
\code{\link{theme_alafoli}()},
\code{\link{theme_apa}()},
\code{\link{theme_booktabs}()},
\code{\link{theme_box}()},
\code{\link{theme_tron_legacy}()},
\code{\link{theme_tron}()},
\code{\link{theme_vanilla}()},
\code{\link{theme_zebra}()}
}
\concept{functions related to themes}
