% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{set_table_properties}
\alias{set_table_properties}
\title{Global table properties}
\usage{
set_table_properties(
  x,
  layout = "fixed",
  width = 0,
  word_title = NULL,
  word_description = NULL
)
}
\arguments{
\item{x}{flextable object}

\item{layout}{'autofit' or 'fixed' algorithm. Default to 'autofit'.}

\item{width}{The parameter has a different effect depending on the
output format. Users should consider it as a minimum width.
In HTML, it is the minimum width of the space that the
table should occupy. In Word, it is a preferred size and Word
may decide not to strictly stick to it. It has no effect on
PowerPoint and PDF output. Its default value is 0, as an effect, it
only use necessary width to display all content. It is not used by the
PDF output.}

\item{word_title}{alternative text for Word table (used as title of the table)}

\item{word_description}{alternative text for Word table (used as description of the table)}
}
\description{
Set table layout and table width. Default to fixed
algorithm.

If layout is fixed, column widths will be used to display the table;
\code{width} is ignored.

If layout is autofit, column widths will not be used;
table width is used (as a percentage).
}
\note{
PowerPoint output ignore 'autofit layout'.
}
\section{Illustrations}{


\if{html}{\figure{fig_set_table_properties_1.png}{options: width="69"}}

\if{html}{\figure{fig_set_table_properties_2.png}{options: width="256"}}

\if{html}{\figure{fig_set_table_properties_3.png}{options: width="500"}}
}

\examples{
library(flextable)
ft_1 <- flextable(head(cars))
ft_1 <- autofit(ft_1)
ft_2 <- set_table_properties(ft_1, width = .5, layout = "autofit")
ft_3 <- set_table_properties(ft_1, width = 1, layout = "autofit")
ft_2
}
\seealso{
Other flextable dimensions: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{flextable dimensions}
