% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{autofit}
\alias{autofit}
\title{Adjusts cell widths and heights}
\usage{
autofit(
  x,
  add_w = 0.1,
  add_h = 0.1,
  part = c("body", "header"),
  unit = "in",
  hspans = "none"
)
}
\arguments{
\item{x}{flextable object}

\item{add_w}{extra width to add in inches}

\item{add_h}{extra height to add in inches}

\item{part}{partname of the table (one of 'all', 'body', 'header' or 'footer')}

\item{unit}{unit for add_h and add_w, one of "in", "cm", "mm".}

\item{hspans}{specifies how cells that are horizontally are included in the calculation.
It must be one of the following values "none", "divided" or "included". If
"none", widths of horizontally spanned cells is set to 0 (then do not affect the
widths); if "divided", widths of horizontally spanned cells is divided by
the number of spanned cells; if "included", all widths (included horizontally
spanned cells) will be used in the calculation.}
}
\description{
compute and apply optimized widths and heights
(minimum estimated widths and heights for each table columns and rows
in inches returned by function \code{\link[=dim_pretty]{dim_pretty()}}).

This function is to be used when the table widths and heights
should be adjusted to fit the size of the content.

The function does not let you adjust a content that is too
wide in a paginated document. It simply calculates the width
of the columns so that each content has the minimum width
necessary to display the content on one line.

Note that this function is not related to 'Microsoft Word'
\emph{Autofit} feature.

There is an alternative to fixed-width layouts that works
well with HTML and Word output that can be set
with \code{set_table_properties(layout = "autofit")}, see
\code{\link[=set_table_properties]{set_table_properties()}}.
}
\section{Illustrations}{


\if{html}{\figure{fig_autofit_1.png}{options: width="500"}}

\if{html}{\figure{fig_autofit_2.png}{options: width="379"}}
}

\examples{
ft_1 <- flextable(head(mtcars))
ft_1
ft_2 <- autofit(ft_1)
ft_2
}
\seealso{
Other flextable dimensions: 
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{set_table_properties}()},
\code{\link{width}()}
}
\concept{flextable dimensions}
